<?php

include_once 'conexao.php';
 
class ModeloChat
{
	//Metodo mdlAddprofessor serve para cadastrar professors na Base de dados
	static public function mdlctrAddMensagem($dados){
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO mensagem (mensagem,dataCadastro,emissor,receptor,estado) VALUES (:mensagem,:dataCadastro,:emissor,:receptor,:estado)");
		
		$stmt->bindParam(":mensagem", $dados["mensagem"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":emissor", $dados["emissor"], PDO::PARAM_STR);
		$stmt->bindParam(":receptor", $dados["receptor"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $dados["estado"], PDO::PARAM_STR);

		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarTodasSms(){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	} 

	static public function mdlMostrarMensagensNaoLidas($receptor){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where  receptor = :r and estado = 'Não visto' order by idMensagem asc limit 15");
			$stmt->bindParam(":r", $receptor, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasMensagensRecebidas($idUsuario){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where  receptor = :r order by idMensagem asc ");
			$stmt->bindParam(":r", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasMensagensRecebidasPorIdUsuarioReceptorEEstado($idUsuario, $estado){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where  receptor = :r and estado = :estado order by idMensagem asc ");
			$stmt->bindParam(":r", $idUsuario, PDO::PARAM_STR);
			$stmt->bindParam(":estado", $estado, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasMensagensEnviada($idUsuario){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where  emissor = :r order by idMensagem asc ");
			$stmt->bindParam(":r", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarMensagemPorIdEmissorOUIddRececeptorEIdMensagem($idUsuario, $idSms){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where  (receptor = :r or emissor = :r) and idMensagem = :idSms order by idMensagem asc ");
			$stmt->bindParam(":r", $idUsuario, PDO::PARAM_STR);
			$stmt->bindParam(":idSms", $idSms, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlActualizarMensagensNaoLidas($emissor,$receptor){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("UPDATE mensagem SET estado = 'Lida'  where  (emissor = :e and receptor = :r and estado = 'Não visto') or (emissor = :r and receptor = :e  and estado = 'Não visto') ");
		$stmt->bindParam(":e", $emissor, PDO::PARAM_STR);
		$stmt->bindParam(":r", $receptor, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC); 
			return $resultado;

	}

	static public function mdlActualizarEstadoDaMensagensNaoLidas($idMensagem){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("UPDATE mensagem SET estado = 'Lida'  where idMensagem = :id ");
		$stmt->bindParam(":id", $idMensagem, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC); 
			return $resultado;

	}

	static public function mdlMostrarMensagensPorIDEmissorEReceptor($emissor,$receptor){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where (emissor = :e and receptor = :r) or (emissor = :r and receptor = :e) order by idMensagem desc ");
		$stmt->bindParam(":e", $emissor, PDO::PARAM_STR);
		$stmt->bindParam(":r", $receptor, PDO::PARAM_STR);
		$stmt->bindParam(":limite", $limite, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarMensagensPorIDEmissorEReceptorPorLimite($emissor,$receptor,$limite){

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM mensagem where (emissor = :e and receptor = :r) or (emissor = :r and receptor = :e) order by idMensagem desc Limit :limite");
		$stmt->bindParam(":e", $emissor, PDO::PARAM_STR);
		$stmt->bindParam(":r", $receptor, PDO::PARAM_STR);
		$stmt->bindParam(":limite", $limite, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

}



  ?>